<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="dynamicmodule__group_feature")
 * @ORM\Entity
 */
class GroupFeature
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Group", inversedBy="filters")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Group $group;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Feature")
	 * @ORM\JoinColumn(name="feature_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Feature $feature;

	/**
	 * @ORM\Column(type="integer", options={"default": 0})
	 */
	public int $position = 0;

	public function __construct(Group $group, Feature $feature, int $position)
	{
		$this->group    = $group;
		$this->feature  = $feature;
		$this->position = $position;
	}

}
