<?php declare(strict_types = 1);

namespace DynamicModule\Model;

use Core\Model\Parameters;
use Core\Model\UI\Form\BaseForm;
use Core\Model\UI\Form\Controls\CheckboxInput;
use Nette\Utils\Arrays;
use Nette\Utils\Json;
use Nette\Utils\Strings;

class Helper
{
	public static function getAllModules(): array
	{
		$arr = [];

		foreach (Parameters::load('adminNavigation') as $menuGroup) {
			foreach ($menuGroup as $menu) {
				$link  = $menu['link'] ?? null;
				$link0 = $link[0] ?? null;
				$link1 = $link[1] ?? null;

				if ($link0 === ':DynamicModule:Admin:Default:' && isset($link1['id'])) {
					$arr[$link1['id']] = $menu['title'];
				}
			}
		}

		return $arr;
	}

	public static function transformTemplateArrayData(array $data, ?\Iterator $components = null): array
	{
		foreach ($data as $k => $c) {
			if (is_array($c) && !Arrays::every(array_keys($c), fn($val) => strlen((string) $val) === 2) && !Arrays::every(array_keys($c), fn($val) => Strings::contains((string) $val, '_'))) {
				if (!is_numeric(key($c))) {
					$data[$k] = Json::encode($c);
				} else {
					foreach ($c as $key => $val) {
						$data[$k][$k . '_' . $val] = $val;
						unset($data[$k][$key]);
					}
				}
			}
		}

		if ($components) {
			foreach ($components as $c) {
				if ($c instanceof CheckboxInput) {
					if ($c->getIsMultiLanguage()) {
						/** @var BaseForm $form */
						$form = $c->form;
						foreach ($form->langsService->getLangs(false) as $lang) {
							if (!isset($data[$c->getName()][$lang->getTag()])) {
								$data[$c->getName()][$lang->getTag()] = '';
							}
						}
					} else {
						$data[$c->getName()] = '';
					}
				}
			}
		}

		return $data;
	}

}
