<?php declare(strict_types = 1);

namespace DynamicModule\Model\Subscribers;

use Contributte\Events\Extra\Event\Application\ShutdownEvent;
use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Sites;
use DynamicModule\FrontModule\Model\FilterUrlHelper;
use Nette\DI\Container;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ApplicationSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;
	protected Translator             $translator;
	protected Sites                  $sites;
	protected Container              $container;
	protected FilterUrlHelper        $filterUrlHelper;

	public function __construct(
		EntityManagerDecorator $em,
		Translator             $translator,
		Sites                  $sites,
		Container              $container,
		FilterUrlHelper        $filterUrlHelper
	)
	{
		$this->em              = $em;
		$this->translator      = $translator;
		$this->sites           = $sites;
		$this->container       = $container;
		$this->filterUrlHelper = $filterUrlHelper;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			ShutdownEvent::class => 'shutdown',
		];
	}

	public function shutdown(ShutdownEvent $event): void
	{
		if (!empty(FilterUrlHelper::$checkExist)) {
			$this->filterUrlHelper->checkExist(FilterUrlHelper::$checkExist);
		}
	}
}
