<?php declare(strict_types=1);

namespace DynamicModule\Model\Traits;

use DynamicModule\Model\Entities\Field;

trait TFields
{
	/**
	 * @return Field[]|array<Field[]>
	 */
	public function getFieldsByKey(): array
	{
		$result = [];
		/** @var Field $v */
		foreach ($this->fields->toArray() as $v) {
			if ($v->lang) {
				$result[$v->key][$v->lang] = $v;
			} else {
				$result[$v->key] = $v;
			}
		}

		return $result;
	}

	public function getFieldsValues(): array
	{
		$result = [];

		/** @var Field $v */
		foreach ($this->fields->toArray() as $v) {
			if ($v->lang) {
				$result[$v->key][$v->lang] = $v->value;
			} else {
				$result[$v->key] = $v->value;
			}
		}

		return $result;
	}

}
