<?php

declare(strict_types=1);

namespace Migrations;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Nette\Neon\Neon;
use Tracy\Debugger;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20210128095930 extends AbstractMigration
{
    public function getDescription() : string
    {
        return '';
    }

    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE dynamicmodule__group_text (lang VARCHAR(2) NOT NULL, group_id INT NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, INDEX IDX_1EAD6C5CFE54D947 (group_id), PRIMARY KEY(group_id, lang)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE dynamicmodule__member_text (lang VARCHAR(2) NOT NULL, member_id INT NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, INDEX IDX_F0D7CCFB7597D3FE (member_id), PRIMARY KEY(member_id, lang)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE dynamicmodule__group_text ADD CONSTRAINT FK_1EAD6C5CFE54D947 FOREIGN KEY (group_id) REFERENCES dynamicmodule__group (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE dynamicmodule__member_text ADD CONSTRAINT FK_F0D7CCFB7597D3FE FOREIGN KEY (member_id) REFERENCES dynamicmodule__member (id) ON DELETE CASCADE');
    }

	public function postUp(Schema $schema): void
	{
		set_time_limit(300);
		parent::postUp($schema);
		try {
			$this->connection->transactional(function (Connection $connection) {
				$configFile  = @file_get_contents(APP_DIR . '/config/app/parameters.neon');
				$appConfig   = Neon::decode($configFile);
				$langs = $appConfig['parameters']['translation']['whitelist'] ?? ['cs'];

				$groups = $this->connection->fetchAll("SELECT id, is_published FROM dynamicmodule__group");

				foreach ($groups as $group) {
					foreach ($langs as $lang) {
						$this->connection->prepare("INSERT INTO dynamicmodule__group_text (lang, group_id, is_published) VALUES (?, ?, ?)")->execute([
							$lang,
							$group['id'],
							$group['is_published'],
						]);
					}
				}

				$members = $this->connection->fetchAll("SELECT id, is_published FROM dynamicmodule__member");

				foreach ($members as $member) {
					foreach ($langs as $lang) {
						$this->connection->prepare("INSERT INTO dynamicmodule__member_text (lang, member_id, is_published) VALUES (?, ?, ?)")->execute([
							$lang,
							$member['id'],
							$member['is_published'],
						]);
					}
				}
			});
		} catch (\Exception $exception) {
			Debugger::log($exception);
		}
	}

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('DROP TABLE dynamicmodule__group_text');
        $this->addSql('DROP TABLE dynamicmodule__member_text');
    }
}
