<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20241106085021 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE dynamicmodule__feature (id INT UNSIGNED AUTO_INCREMENT NOT NULL, position INT NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, INDEX published (id, is_published), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE dynamicmodule__feature_text (lang VARCHAR(2) NOT NULL, id INT UNSIGNED NOT NULL, name VARCHAR(255) DEFAULT NULL, INDEX IDX_24249DABBF396750 (id), INDEX feature (id, lang), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE dynamicmodule__feature_value (id INT UNSIGNED AUTO_INCREMENT NOT NULL, feature_id INT UNSIGNED DEFAULT NULL, position INT NOT NULL, is_published SMALLINT DEFAULT 1, INDEX IDX_596CDA7D60E4B879 (feature_id), INDEX published (id, is_published), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE dynamicmodule__feature_value_text (lang VARCHAR(2) NOT NULL, id INT UNSIGNED NOT NULL, name LONGTEXT DEFAULT NULL, INDEX IDX_4B17E06BF396750 (id), INDEX feature_value (id, lang), PRIMARY KEY(id, lang)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE dynamicmodule__group_feature (group_id INT NOT NULL, feature_id INT UNSIGNED NOT NULL, position INT DEFAULT 0 NOT NULL, INDEX IDX_1492A92AFE54D947 (group_id), INDEX IDX_1492A92A60E4B879 (feature_id), PRIMARY KEY(group_id, feature_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE dynamicmodule__virtual_url (id INT UNSIGNED AUTO_INCREMENT NOT NULL, is_locked SMALLINT UNSIGNED DEFAULT 0 NOT NULL, site_ident VARCHAR(255) NOT NULL, created DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL, relation_hash VARCHAR(50) DEFAULT NULL, UNIQUE INDEX UNIQ_281A0FC866926135 (relation_hash), INDEX dmvu_hash (relation_hash), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE dynamicmodule__virtual_url_feature_value (virtual_url_id INT UNSIGNED NOT NULL, feature_value_id INT UNSIGNED NOT NULL, INDEX IDX_B56DCA65F556E34D (virtual_url_id), INDEX IDX_B56DCA6580CD149D (feature_value_id), PRIMARY KEY(virtual_url_id, feature_value_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE dynamicmodule__virtual_url_text (locale VARCHAR(255) NOT NULL, id INT UNSIGNED NOT NULL, url VARCHAR(255) NOT NULL, seo_title VARCHAR(255) DEFAULT NULL, seo_description VARCHAR(255) DEFAULT NULL, title VARCHAR(255) DEFAULT NULL, description LONGTEXT DEFAULT NULL, texts LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', INDEX IDX_AB44EC9CBF396750 (id), INDEX dmvu_url_locale (url, locale), PRIMARY KEY(id, locale)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE dynamicmodule__feature_text ADD CONSTRAINT FK_24249DABBF396750 FOREIGN KEY (id) REFERENCES dynamicmodule__feature (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE dynamicmodule__feature_value ADD CONSTRAINT FK_596CDA7D60E4B879 FOREIGN KEY (feature_id) REFERENCES dynamicmodule__feature (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE dynamicmodule__feature_value_text ADD CONSTRAINT FK_4B17E06BF396750 FOREIGN KEY (id) REFERENCES dynamicmodule__feature_value (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE dynamicmodule__group_feature ADD CONSTRAINT FK_1492A92AFE54D947 FOREIGN KEY (group_id) REFERENCES dynamicmodule__group (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE dynamicmodule__group_feature ADD CONSTRAINT FK_1492A92A60E4B879 FOREIGN KEY (feature_id) REFERENCES dynamicmodule__feature (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE dynamicmodule__virtual_url_feature_value ADD CONSTRAINT FK_B56DCA65F556E34D FOREIGN KEY (virtual_url_id) REFERENCES dynamicmodule__virtual_url (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE dynamicmodule__virtual_url_feature_value ADD CONSTRAINT FK_B56DCA6580CD149D FOREIGN KEY (feature_value_id) REFERENCES dynamicmodule__feature_value (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE dynamicmodule__virtual_url_text ADD CONSTRAINT FK_AB44EC9CBF396750 FOREIGN KEY (id) REFERENCES dynamicmodule__virtual_url (id) ON DELETE CASCADE');
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE dynamicmodule__feature_text DROP FOREIGN KEY FK_24249DABBF396750');
		$this->addSql('ALTER TABLE dynamicmodule__feature_value DROP FOREIGN KEY FK_596CDA7D60E4B879');
		$this->addSql('ALTER TABLE dynamicmodule__group_feature DROP FOREIGN KEY FK_1492A92A60E4B879');
		$this->addSql('ALTER TABLE dynamicmodule__feature_value_text DROP FOREIGN KEY FK_4B17E06BF396750');
		$this->addSql('ALTER TABLE dynamicmodule__virtual_url_feature_value DROP FOREIGN KEY FK_B56DCA6580CD149D');
		$this->addSql('ALTER TABLE dynamicmodule__virtual_url_feature_value DROP FOREIGN KEY FK_B56DCA65F556E34D');
		$this->addSql('ALTER TABLE dynamicmodule__virtual_url_text DROP FOREIGN KEY FK_AB44EC9CBF396750');
		$this->addSql('DROP TABLE dynamicmodule__feature');
		$this->addSql('DROP TABLE dynamicmodule__feature_text');
		$this->addSql('DROP TABLE dynamicmodule__feature_value');
		$this->addSql('DROP TABLE dynamicmodule__feature_value_text');
		$this->addSql('DROP TABLE dynamicmodule__group_feature');
		$this->addSql('DROP TABLE dynamicmodule__virtual_url');
		$this->addSql('DROP TABLE dynamicmodule__virtual_url_feature_value');
		$this->addSql('DROP TABLE dynamicmodule__virtual_url_text');
	}
}
