<?php declare(strict_types = 1);

namespace DynamicModule\AdminModule\Components;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use DynamicModule\AdminModule\Model\Events\GroupEvent;
use DynamicModule\FrontModule\Model\Repository\Groups;
use DynamicModule\Model\Entities\Group;
use DynamicModule\Model\Entities\GroupMember;
use DynamicModule\Model\Repository\GroupMembers;
use DynamicModule\Model\Repository\Members;
use Nette\Caching\Cache;

class GroupDetail extends BaseControl
{
	protected ?Group $group = null;

	public function __construct(protected GroupMembers $groupMembers, protected Members $members)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	public function createComponentGrid(): BaseDataGrid
	{
		EntityManagerDecorator::$useDoctrineQuery = true;
		$qb                                       = $this->members->getQueryBuilderByGroup($this->group->getId());

		$grid = $this->createGrid();
		$grid->setItemsPerPageList([], true);
		$grid->setDataSource($qb)
			->setSortable()
			->setSortableHandler('groupsGrid:groupDetail:sort!');

		$grid->addColumnText('title', 'default.title')
			->setRenderer(static fn(GroupMember $groupMember): string => $groupMember->member->title);

		return $grid;
	}

	public function setGroup(Group $group): void
	{
		$this->group = $group;
	}

	public function handleSort(): void
	{
		$presenter     = $this->presenter;
		$request       = $presenter->getHttpRequest();
		$groupMemberId = $request->getPost('id');
		$position      = $request->getPost('position');
		$groupMember   = $this->groupMembers->get((int) $groupMemberId);

		if ($groupMemberId != null && $position != null && $groupMember !== null) {
			$groupMember->position = (int) $position;
			$this->em->persist($groupMember);
			$this->em->flush();
			$presenter->flashMessageSuccess('default.positionChanged');
			$group = $groupMember->group;
			$this->eventDispatcher->dispatch(
				new GroupEvent($group),
				'dynamicModule.admin.' . $group->moduleKey . '.groupChanged',
			);

			$cache = new Cache(
				$this->cacheStorage, Groups::CACHE_NAMESPACE
			);
			foreach ($this->langsService->getLangs(false) as $lang) {
				$cache->remove(md5((string) $groupMember->group->getId()) . '_' . $lang->getTag());
			}
			$cache->clean([Cache::Tags => [Groups::CACHE_NAMESPACE]]);
		} else {
			$presenter->flashMessageDanger('default.positionChangeFailed');
		}

		$presenter->redrawControl('flashes');
	}

}
