<?php declare(strict_types = 1);

namespace DynamicModule\AdminModule\Presenters;

use Nette\Application\BadRequestException;

abstract class BasePresenter extends \Core\AdminModule\Presenters\BasePresenter
{
	/**
	 * @param mixed $element
	 *
	 * @throws BadRequestException
	 */
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);
		$moduleKey = $this->getParameter('id');
		if (!$moduleKey || !$this->getUser()
				->isAllowed($this->getFullModuleName() . ':' . ucfirst((string) $moduleKey), 'access')) {
			$this->error();
		}
	}
}
