<?php declare(strict_types = 1);

namespace DynamicModule\AdminModule\Presenters;

use DynamicModule\AdminModule\Components\GroupsGrid;
use DynamicModule\AdminModule\Components\IGroupsGridFactory;
use DynamicModule\AdminModule\Components\IMembersGridFactory;
use DynamicModule\AdminModule\Components\MembersGrid;
use DynamicModule\Model\Repository\Groups;
use DynamicModule\Model\Repository\Members;
use function str_contains;

class DefaultPresenter extends BasePresenter
{
	/** @var string */
	protected string $moduleKey;

	/** @var Groups @inject */
	public Groups $groups;

	/** @var Members @inject */
	public Members $members;

	protected function startup(): void
	{
		parent::startup();
		$this->moduleKey = $this->getParameter('id');
	}

	public function actionDefault(mixed $id): void
	{
		if ($navigationItem = $this->searchNavigationItem($this->moduleKey, $this['navigationSidebar']->getData())) {
			$this->setHeader($navigationItem['title'], $navigationItem['ico']);
			$this->setTitle($this->t($navigationItem['title']));
		}

		$this['navigation']->setData([
			'header' => [
				[
					'title' => 'dynamicModule.menu.addMember',
					'ico'   => 'plus',
					'link'  => $this->link('membersGrid:add!'),
					'class' => 'ajax',
				],
				[
					'title' => 'dynamicModule.menu.addGroup',
					'ico'   => 'plus',
					'link'  => $this->link('groupsGrid:add!'),
					'class' => 'ajax',
				],
			],
		]);
	}

	public function createComponentMembersGrid(IMembersGridFactory $factory): MembersGrid
	{
		return $factory->create($this->moduleKey);
	}

	public function createComponentGroupsGrid(IGroupsGridFactory $factory): GroupsGrid
	{
		return $factory->create($this->moduleKey);
	}

	protected function searchNavigationItem(string $needle, array $haystack): ?array
	{
		foreach ($haystack as $key => $value) {
			$link = $value[$needle]['link'][0];
			if (is_array($value[$needle]['link']) && $link !== null && str_contains((string) $link, 'DynamicModule')) {
				return $value[$needle];
			}
		}

		return null;
	}

}
