<?php declare(strict_types = 1);

namespace DynamicModule\FrontModule\Model\Dao;

use Nette\SmartObject;

/**
 * @property-read int    $id
 * @property-read string $key
 * @property-read string $lang
 * @property string      $value
 */
class Field
{
	use SmartObject;

	/** @var string|object|null */
	protected $value;

	public function __construct(protected string $key, ?string $value, protected ?string $lang, protected int $id)
	{
		$this->value = $value;
	}

	public function getId(): int
	{
		return $this->id;
	}

	public function getKey(): string
	{
		return $this->key;
	}

	public function getValue(): string|object|null
	{
		return $this->value;
	}

	/**
	 * @param string|object|null $value
	 */
	public function setValue($value): void
	{
		$this->value = $value;
	}

	public function getLang(): ?string
	{
		return $this->lang;
	}

}
