<?php declare(strict_types = 1);

namespace DynamicModule\FrontModule\Model\Dao;

use Core\FrontModule\Model\Dao\Seo;
use Nette\SmartObject;

/**
 * @property-read int    $id
 * @property string      $title
 * @property string|null $lang
 * @property string      $template
 * @property Field[]     $fields
 */
class Member implements IFields
{
	use SmartObject;
	use TFields;

	protected ?string $lang     = null;
	protected array   $groupIds = [];
	public ?string    $module   = null;
	public ?Seo       $seo      = null;

	public function __construct(protected int $id, protected string $title, protected string $template)
	{
	}

	public function getId(): int
	{
		return $this->id;
	}

	public function getTitle(): string
	{
		return $this->title;
	}

	public function setTitle(string $title): void
	{
		$this->title = $title;
	}

	public function getLang(): ?string
	{
		return $this->lang;
	}

	public function setLang(?string $lang): void
	{
		$this->lang = $lang;
	}

	public function getTemplate(): string
	{
		return $this->template;
	}

	public function setTemplate(string $template): void
	{
		$this->template = $template;
	}

	public function setGroupIds(array $groupIds): void { $this->groupIds = $groupIds; }

	public function getGroupIds(): array { return $this->groupIds; }
}
