<?php declare(strict_types = 1);

namespace DynamicModule\FrontModule\Model\Dao;

use Core\Model\Helpers\Arrays;
use function str_contains;
use function str_starts_with;

trait TFields
{
	/** @var Field[] */
	protected array $fields;

	/**
	 * @inheritDoc
	 */
	public function getField(string $key)
	{
		return $this->fields[$key] ?? null;
	}

	/**
	 * @inheritDoc
	 */
	public function getFieldValue(string $key)
	{
		$field = $this->getField($key);

		if (!$field) {
			return null;
		}

		if (is_array($field)) {
			return array_map(static fn($f) => $f->getValue(), $field);
		}

		return $field->getValue();
	}

	/**
	 * @inheritDoc
	 */
	public function getFields(): array
	{
		return $this->fields;
	}

	/**
	 * @inheritDoc
	 */
	public function setFields(array $fields): void
	{
		// z tt image, nebo checkbox udela pole hodnot (xx_s, xx_y na [xx => [s, y]])
		$skip = [];
		$tmp  = $fields;
		foreach ($fields as $k1 => $f1) {
			if (Arrays::contains($skip, $k1)) {
				continue;
			}

			if (str_contains($k1, '_')) {
				foreach ($fields as $k2 => $f2) {
					[$keyBefore, $keyAfter] = explode('_', $k2);
					if (str_starts_with($k2, $keyBefore . '_')) {
						$skip[]                     = $k2;
						$tmp[$keyBefore][$keyAfter] = $f2;
					}
				}
			}
		}
		$this->fields = $tmp;
	}

	public function getKeyValueData(): array
	{
		$arr = [];

		foreach ($this->getFields() as $k1 => $v1) {
			if (is_array($v1)) {
				foreach ($v1 as $k2 => $v2) {
					$arr[$k1][$k2] = $v2->getValue();
				}
			} else {
				$arr[$k1] = $v1->getValue();
			}
		}

		return $arr;
	}
}
