<?php

declare(strict_types = 1);

namespace DynamicModule\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200323105950 extends AbstractMigration
{
	public function getDescription(): string
	{
		return '';
	}

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql(
			'CREATE TABLE dynamicmodule__field (id INT AUTO_INCREMENT NOT NULL, `key` VARCHAR(255) NOT NULL, value LONGTEXT DEFAULT NULL, lang VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE dynamicmodule__group (id INT AUTO_INCREMENT NOT NULL, parent_id INT DEFAULT NULL, tree_root INT DEFAULT NULL, module_key VARCHAR(255) NOT NULL, title VARCHAR(255) NOT NULL, lft INT NOT NULL, lvl INT NOT NULL, rgt INT NOT NULL, template VARCHAR(255) NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, INDEX IDX_746063E2727ACA70 (parent_id), INDEX IDX_746063E2A977936C (tree_root), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE dynamicmodule__group_fields (group_id INT NOT NULL, field_id INT NOT NULL, INDEX IDX_E0E68E47FE54D947 (group_id), INDEX IDX_E0E68E47443707B0 (field_id), PRIMARY KEY(group_id, field_id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE dynamicmodule__group_member (id INT AUTO_INCREMENT NOT NULL, group_id INT DEFAULT NULL, member_id INT DEFAULT NULL, position INT NOT NULL, INDEX IDX_EEE797B7FE54D947 (group_id), INDEX IDX_EEE797B77597D3FE (member_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE dynamicmodule__member (id INT AUTO_INCREMENT NOT NULL, title VARCHAR(255) NOT NULL, lang VARCHAR(2) DEFAULT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, template VARCHAR(255) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE dynamicmodule__member_fields (member_id INT NOT NULL, field_id INT NOT NULL, INDEX IDX_D776E9FB7597D3FE (member_id), INDEX IDX_D776E9FB443707B0 (field_id), PRIMARY KEY(member_id, field_id)) DEFAULT CHARACTER SET UTF8 COLLATE `UTF8_unicode_ci` ENGINE = InnoDB',
		);
		$this->addSql(
			'ALTER TABLE dynamicmodule__group ADD CONSTRAINT FK_746063E2727ACA70 FOREIGN KEY (parent_id) REFERENCES dynamicmodule__group (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE dynamicmodule__group ADD CONSTRAINT FK_746063E2A977936C FOREIGN KEY (tree_root) REFERENCES dynamicmodule__group (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE dynamicmodule__group_fields ADD CONSTRAINT FK_E0E68E47FE54D947 FOREIGN KEY (group_id) REFERENCES dynamicmodule__group (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE dynamicmodule__group_fields ADD CONSTRAINT FK_E0E68E47443707B0 FOREIGN KEY (field_id) REFERENCES dynamicmodule__field (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE dynamicmodule__group_member ADD CONSTRAINT FK_EEE797B7FE54D947 FOREIGN KEY (group_id) REFERENCES dynamicmodule__group (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE dynamicmodule__group_member ADD CONSTRAINT FK_EEE797B77597D3FE FOREIGN KEY (member_id) REFERENCES dynamicmodule__member (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE dynamicmodule__member_fields ADD CONSTRAINT FK_D776E9FB7597D3FE FOREIGN KEY (member_id) REFERENCES dynamicmodule__member (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE dynamicmodule__member_fields ADD CONSTRAINT FK_D776E9FB443707B0 FOREIGN KEY (field_id) REFERENCES dynamicmodule__field (id) ON DELETE CASCADE',
		);
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf(
			$this->connection->getDatabasePlatform()
				->getName() !== 'mysql',
			'Migration can only be executed safely on \'mysql\'.',
		);

		$this->addSql('ALTER TABLE dynamicmodule__group_fields DROP FOREIGN KEY FK_E0E68E47443707B0');
		$this->addSql('ALTER TABLE dynamicmodule__member_fields DROP FOREIGN KEY FK_D776E9FB443707B0');
		$this->addSql('ALTER TABLE dynamicmodule__group DROP FOREIGN KEY FK_746063E2727ACA70');
		$this->addSql('ALTER TABLE dynamicmodule__group DROP FOREIGN KEY FK_746063E2A977936C');
		$this->addSql('ALTER TABLE dynamicmodule__group_fields DROP FOREIGN KEY FK_E0E68E47FE54D947');
		$this->addSql('ALTER TABLE dynamicmodule__group_member DROP FOREIGN KEY FK_EEE797B7FE54D947');
		$this->addSql('ALTER TABLE dynamicmodule__group_member DROP FOREIGN KEY FK_EEE797B77597D3FE');
		$this->addSql('ALTER TABLE dynamicmodule__member_fields DROP FOREIGN KEY FK_D776E9FB7597D3FE');
		$this->addSql('DROP TABLE dynamicmodule__field');
		$this->addSql('DROP TABLE dynamicmodule__group');
		$this->addSql('DROP TABLE dynamicmodule__group_fields');
		$this->addSql('DROP TABLE dynamicmodule__group_member');
		$this->addSql('DROP TABLE dynamicmodule__member');
		$this->addSql('DROP TABLE dynamicmodule__member_fields');
	}
}
