<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'dynamicmodule__field')]
#[ORM\Entity]
class Field
{
	use TId;

	#[ORM\Column(name: '`key`', type: Types::STRING, length: 255, nullable: false)]
	public string $key;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $value;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $lang;

	/**
	 * Field constructor.
	 *
	 * @param string      $key
	 * @param null        $value
	 * @param string|null $lang
	 */
	public function __construct(string $key, $value = null, string $lang = null)
	{
		$this->key   = $key;
		$this->value = $value;
		$this->lang  = $lang;
	}

}
