<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'dynamicmodule__group_text')]
#[ORM\Entity]
class GroupText
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Group::class, cascade: ['persist', 'remove'], inversedBy: 'texts')]
	#[ORM\JoinColumn(name: 'group_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public Group $group;

	#[ORM\Id]
	#[ORM\Column(name: 'lang', type: Types::STRING, length: 2, nullable: true)]
	protected string $lang;

	#[ORM\Column(type: Types::SMALLINT, length: 1, options: ['default' => 0])]
	public int $isPublished = 0;

	public function __construct(Group $group, string $lang)
	{
		$this->group = $group;
		$this->lang  = $lang;
	}

	public function getGroup(): Group
	{
		return $this->group;
	}

	public function getLang(): string
	{
		return $this->lang;
	}
}
