<?php declare(strict_types = 1);

namespace DynamicModule\Model\Entities;

use Core\Model\Entities\Seo;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'dynamicmodule__member_text')]
#[ORM\Entity]
class MemberText
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Member::class, cascade: ['persist', 'remove'], inversedBy: 'texts')]
	#[ORM\JoinColumn(name: 'member_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public Member $member;

	#[ORM\Id]
	#[ORM\Column(name: 'lang', type: Types::STRING, length: 2, nullable: true)]
	protected string $lang;

	#[ORM\ManyToOne(targetEntity: Seo::class)]
	#[ORM\JoinColumn(name: 'seo_id', referencedColumnName: 'id', nullable: true, onDelete: 'SET NULL')]
	public ?Seo $seo = null;

	#[ORM\Column(type: Types::SMALLINT, length: 1, options: ['default' => 0])]
	public int $isPublished = 0;

	public function __construct(Member $member, string $lang)
	{
		$this->member = $member;
		$this->lang   = $lang;
	}

	public function getMember(): Member
	{
		return $this->member;
	}

	public function getLang(): string
	{
		return $this->lang;
	}
}
