<?php declare(strict_types = 1);

namespace Ecomail\DI;

use Core\DI\CompilerExtension;
use Nette;

class EcomailExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Ecomail' => 'Ecomail\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods['initialize'];
		$builder = $this->getContainerBuilder();

		$init->addBody('Ecomail\Model\EcomailConfig::setParams(?);', [$builder->parameters['ecomail']]);
	}
}
