<?php declare(strict_types = 1);

namespace Ecomail\FrontModule\Model\Subscribers;

use Ecomail\Model\Dao\ListSubscribe;
use Ecomail\Model\Dao\Subscriber;
use Ecomail\Model\Ecomail;
use Ecomail\Model\EcomailConfig;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Core\Model\Entities\EntityManagerDecorator;
use Users\Model\Event\UserEvent;

class RegisterFormSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;
	protected Ecomail $ecomail;

	public function __construct(EntityManagerDecorator $em, Ecomail $ecomail)
	{
		$this->em      = $em;
		$this->ecomail = $ecomail;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'users.registerForm.afterSave' => 'formSuccess',
		];
	}

	public function formSuccess(UserEvent $event): void
	{
		if (!EcomailConfig::load('apiKey')) {
			return;
		}

		$user   = $event->user;
		$values = $event->data['formValues'];

		if ($values->newsletterSubscribe) {
			$confLists = EcomailConfig::load('lists');
			$confList  = $confLists['default'];

			$subscriber = new Subscriber($user->getName() ?? '', $user->getLastname() ?? '', $user->getEmail());

			$list                        = new ListSubscribe($subscriber, (int) $confList['id']);
			$list->triggerAutoresponders = $confList['triggerAutoresponders'];
			$list->updateExisting        = $confList['updateExisting'];
			$list->resubscribe           = $confList['resubscribe'];
			$list->skipConfirmation      = $confList['skipConfirmation'];
			$list->triggerNotification   = $confList['triggerNotification'];

			foreach ($confList['addCustomerToGroup'] as $groupKey => $data) {
				if (isset($data['no'])) {
					$list->groups[$groupKey] = $data['no'];
				}
			}

			$this->ecomail->addSubscriber($list);
		}
	}
}
