<?php declare(strict_types = 1);

namespace Ecomail\Model\Dao;

class ListSubscribe
{
	public Subscriber $subscriber;
	public int        $listId;
	public array      $groups = [];

	public bool $triggerAutoresponders = true;
	public bool $updateExisting        = true;
	public bool $resubscribe           = true;
	public bool $skipConfirmation      = true;
	public bool $triggerNotification   = true;

	public function __construct(Subscriber $subscriber, int $listId)
	{
		$this->subscriber = $subscriber;
		$this->listId     = $listId;
	}

	public function toEcomailArray(): array
	{
		$d = [
			'subscriber_data'        => $this->subscriber->toEcomailArray(),
			'group'                  => $this->groups,
			'trigger_autoresponders' => $this->triggerAutoresponders,
			'update_existing'        => $this->updateExisting,
			'resubscribe'            => $this->resubscribe,
			'skip_confirmation'      => $this->skipConfirmation,
			'trigger_notification'   => $this->triggerNotification,
		];

		foreach ($d as $k => $v) {
			if (empty($v)) {
				unset($d[$k]);
			}
		}

		return $d;
	}
}
