<?php declare(strict_types = 1);

namespace Ecomail\Model\Dao;

use DateTimeInterface;

class Subscriber
{
	public string             $name;
	public string             $surname;
	public string             $email;
	public ?string            $company      = null;
	public ?string            $city         = null;
	public ?string            $street       = null;
	public ?string            $zip          = null;
	public ?string            $country      = null;
	public ?string            $phone        = null;
	public ?string            $preTitle     = null;
	public ?string            $surTitle     = null;
	public ?DateTimeInterface $birthday     = null;
	public array              $customFields = [];
	public array              $tags         = [];

	public function __construct(string $name, string $surname, string $email)
	{
		$this->name    = $name;
		$this->surname = $surname;
		$this->email   = $email;
	}

	public function toEcomailArray(): array
	{
		$r = [
			'name'          => $this->name,
			'surname'       => $this->surname,
			'email'         => $this->email,
			'company'       => $this->company,
			'city'          => $this->city,
			'street'        => $this->street,
			'zip'           => $this->zip,
			'country'       => $this->country ? strtoupper($this->country) : null,
			'phone'         => $this->phone,
			'pretitle'      => $this->preTitle,
			'surtitle'      => $this->surTitle,
			'birthday'      => $this->birthday,
			'custom_fields' => $this->customFields,
			'tags'          => $this->tags,
		];

		foreach ($r as $k => $v)
			if ($v === null || empty($v))
				unset($r[$k]);

		return $r;
	}
}
