<?php declare(strict_types = 1);

namespace Ecomail\Model\Dao;

class Transaction
{
	/** @var TransactionItem[] */
	protected array           $items   = [];
	public string             $orderId;
	public string             $email;
	public string             $shop;
	public float              $shipping;
	public ?string            $city    = null;
	public ?string            $county  = null;
	public ?string            $country = null;
	public array              $props   = [];

	public function __construct(string $orderId, string $email, string $shop, float $shipping)
	{
		$this->orderId  = $orderId;
		$this->email    = $email;
		$this->shop     = $shop;
		$this->shipping = $shipping;
	}

	public function addItem(TransactionItem $item): void
	{
		$this->items[] = $item;
	}

	/**
	 * @return TransactionItem[]
	 */
	public function getItems(): array { return $this->items; }

	public function getPrice(): float
	{
		$price = 0;

		foreach ($this->getItems() as $item) {
			$price += $item->getTotalPrice();
		}

		return $price;
	}

	public function toEcomailArray(): array
	{
		$d = [
			'transaction'       => [
				'order_id'  => $this->orderId,
				'email'     => $this->email,
				'shop'      => $this->shop,
				'amount'    => round($this->getPrice(), 2),
				'shipping'  => round($this->shipping, 2),
				'city'      => $this->city,
				'county'    => $this->county,
				'country'   => $this->country,
				'timestamp' => time(),
				'props'     => $this->props,
			],
			'transaction_items' => array_map(static function(TransactionItem $item) { return $item->toEcomailArray(); }, $this->getItems()),
		];

		foreach ($d['transaction'] as $k => $v) {
			if ($v === null || empty($v)) {
				unset($d['transaction'][$k]);
			}
		}

		return $d;
	}
}
