<?php declare(strict_types = 1);

namespace Ecomail\Model\Dao;

class TransactionItem
{
	public string $id;
	public string $name;
	public string $category;
	public float  $pricePerPiece;
	public int    $quantity;

	public function __construct(string $id, string $name, string $category, float $pricePerPiece, int $quantity)
	{
		$this->id            = $id;
		$this->name          = $name;
		$this->category      = $category;
		$this->pricePerPiece = $pricePerPiece;
		$this->quantity      = $quantity;
	}

	public function getTotalPrice(): float { return round($this->quantity * $this->pricePerPiece, 2); }

	public function toEcomailArray(): array
	{
		return [
			'code'      => $this->id,
			'title'     => $this->name,
			'category'  => $this->category,
			'price'     => $this->pricePerPiece,
			'amount'    => $this->quantity,
			'timestamp' => time(),
		];
	}
}
