<?php declare(strict_types = 1);

namespace Ecomail\Model;

use Ecomail as ApiEcomail;
use Ecomail\Model\Dao\ListSubscribe;
use Ecomail\Model\Dao\Transaction;
use stdClass;
use Tracy\Debugger;

class Ecomail
{
	protected function getApi(): ?ApiEcomail
	{
		$apiKey = EcomailConfig::load('apiKey');

		if (!$apiKey) {
			Debugger::log('Missing api key', 'ecomail');

			return null;
		}

		return new ApiEcomail($apiKey);
	}

	/**
	 * @return array|stdClass|string
	 */
	public function addSubscriber(ListSubscribe $listSubscribe)
	{
		$api = $this->getApi();

		return $api
			? $api->addSubscriber((string) $listSubscribe->listId, $listSubscribe->toEcomailArray())
			: [];
	}

	/**
	 * @param Transaction $transaction
	 *
	 * @return array|stdClass|string
	 */
	public function createNewTransaction(Transaction $transaction)
	{
		$api = $this->getApi();

		return $api
			? $api->createNewTransaction($transaction->toEcomailArray())
			: [];
	}

}
