<?php declare(strict_types = 1);

namespace Ecomail\Model\Entities;

use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;
use EshopOrders\Model\Entities\Order;

/**
 * @ORM\Table(name="ecomail__order")
 * @ORM\Entity
 */
class EcomailOrder
{
	/**
	 * @ORM\Id
	 * @ORM\OneToOne(targetEntity="\EshopOrders\Model\Entities\Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected Order $order;

	/**
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	protected ?DateTimeInterface $exported = null;

	public function __construct(Order $order)
	{
		$this->order = $order;
	}

	public function getOrder(): Order { return $this->order; }

	public function export(?DateTimeInterface $datetime = null): self
	{
		$this->exported = $datetime ?? new DateTime;

		return $this;
	}

	public function getExported(): ?DateTimeInterface { return $this->exported; }
}
