<?php declare(strict_types = 1);

namespace Ecomail\Model\Helpers;

use Ecomail\Model\Dao\Subscriber;
use EshopOrders\Model\Entities\OrderAddress;

class OrderHelper
{
	public static function fillSubscriber(OrderAddress $address): Subscriber
	{
		$s = new Subscriber($address->getFirstName(), $address->getLastName(), $address->getEmail());

		if ($address->getCompany())
			$s->company = $address->getCompany();
		if ($address->getCity())
			$s->city = $address->getCity();
		if ($address->getStreet())
			$s->street = $address->getStreet();
		if ($address->getPostal())
			$s->zip = $address->getPostal();
		if ($address->getCountry())
			$s->country = $address->getCountry()->getId();
		if ($address->getPhone())
			$s->phone = $address->getPhone();

		return $s;
	}
}
