<?php declare(strict_types=1);

namespace Eet\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\BaseWidgetControl;
use Eet\Model\Entities\EetProps;
use Eet\Model\Repository\OrderReceipts;

class EetStatus extends BaseWidgetControl
{
	/** @var int */
	protected int $orderId;

	/** @var OrderReceipts */
	protected OrderReceipts $orderReceipts;

	/** @var EetProps|null */
	protected ?EetProps $eetProps;

	/**
	 * EetStatus constructor.
	 * @param int $orderId
	 * @param OrderReceipts $orderReceipts
	 */
	public function __construct(int $orderId, OrderReceipts $orderReceipts)
	{
		$this->orderId = $orderId;
		$this->orderReceipts = $orderReceipts;
		$this->orderReceipt = $this->orderReceipts->get($this->orderId);
	}

	public function render(): void
	{
		$this->template->orderReceipt = $this->orderReceipts->get($this->orderId);
		$this->template->render($this->getTemplateFile());
	}

	/**
	 * @return string
	 */
	public function getTitle(): string
	{
		return $this->t('eet.editOrder.title');
	}

	/**
	 * @return bool
	 */
	public function skip(): bool
	{
		return !$this->orderReceipts->meetsRequirementsForOrderReceipt($this->orderId);
	}

}