<?php declare(strict_types=1);

namespace Eet\Model\Entities;

use EshopOrders\Model\Entities\Order;
use Nette\Utils\DateTime;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Nette\Utils\Strings;

/**
 * @ORM\Table(name="eet__eet_props")
 * @ORM\Entity
 */
class EetProps
{
	/**
	 * @var Order
	 * @ORM\Id
	 * @ORM\OneToOne(targetEntity="EshopOrders\Model\Entities\Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Order $order;

	/**
	 * @var string
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $checkout;

	/**
	 * @var string
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $premise;

	/**
	 * @var DateTime
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(name="created", type="datetime")
	 */
	public $created;

	/**
	 * @var string
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $bkp;

	/**
	 * @var string|null
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $pkp;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $fik;

	/**
	 * @var bool
	 * @ORM\Column(type="boolean", nullable=false)
	 */
	public bool $isOk;

	/**
	 * OrderReceipt constructor.
	 * @param Order $order
	 * @param bool $isOk
	 * @param int $number
	 * @param string $checkout
	 * @param string $premise
	 * @param string $bkp
	 * @param string|null $pkp
	 * @param string|null $fik
	 */
	public function __construct(Order $order, bool $isOk, int $number, string $checkout, string $premise, string $bkp, ?string $pkp, ?string $fik)
	{
		$this->order = $order;
		$this->isOk = $isOk;
		$this->number = $number;
		$this->checkout = $checkout;
		$this->premise = $premise;
		$this->bkp = $bkp;
		$this->pkp = $pkp;
		$this->fik = $fik;
	}

	/**
	 * @return bool
	 */
	public function isOk(): bool
	{
		return $this->fik !== null;
	}

}