<?php declare(strict_types=1);

namespace Eet\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Seller;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="eet__seller_receipt_config")
 * @ORM\Entity
 */
class SellerReceiptConfig
{
	/**
	 * @var Seller
	 * @ORM\Id
	 * @ORM\OneToOne(targetEntity="EshopCatalog\Model\Entities\Seller")
	 * @ORM\JoinColumn(name="seller_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $seller;

	/**
	 * @var int
	 * @ORM\Column(type="integer", nullable=false, options={"default":0})
	 */
	public int $counter = 0;

	/**
	 * @var string
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $checkout;

	/**
	 * @var string
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $premise;

	/**
	 * SellerReceiptConfig constructor.
	 * @param Seller $seller
	 * @param string $checkout
	 * @param string $premise
	 */
	public function __construct(Seller $seller, string $checkout, string $premise)
	{
		$this->seller = $seller;
		$this->checkout = $checkout;
		$this->premise = $premise;
	}

}