<?php declare(strict_types=1);

namespace Eet\Model\Events;

use EshopOrders\Model\Entities\Order;
use Nette\SmartObject;

/**
 * Class OrderPaidEvent
 * @package Eet\Model\Events
 * @property-read Order $order
 */
class OrderPaidEvent
{
	use SmartObject;

	/** @var Order */
	protected Order $order;

	/**
	 * OrderPaidEvent constructor.
	 * @param Order $order
	 */
	public function __construct(Order $order)
	{
		$this->order = $order;
	}

	/**
	 * @return Order
	 */
	public function getOrder(): Order
	{
		return $this->order;
	}

}