<?php declare(strict_types=1);

namespace Eet\Model\Repository;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\Query\Expr\Join;
use Eet\Model\Entities\EetProps;
use EshopOrders\Model\Entities\Order;

/**
 * Class OrderReceipts
 * @package Eet\Model\Repository
 * @method EetProps[] getAll()
 */
class OrderReceipts extends BaseEntityService
{
	/** @var string */
	protected $entityClass = EetProps::class;

	/**
	 * @param int $sellerId
	 * @return EetProps|null
	 */
	public function get(int $sellerId): ?EetProps
	{
		$qb = $this->getEr()->createQueryBuilder('recp');
		$qb->join('recp.order', 'o')
		   ->where($qb->expr()->eq('o.id', $sellerId));

		return $qb->getQuery()->getOneOrNullResult();
	}

	/**
	 * @param int $orderId
	 * @return bool
	 */
	public function meetsRequirementsForOrderReceipt(int $orderId): bool
	{
		// TODO stav (cash) bude jiny
		$qb = $this->em->createQueryBuilder();
		$qb->select('o')
			->from(Order::class, 'o')
			->join('o.payment', 'op')
			->join('op.payment', 'p', Join::WITH, 'p.ident = :payment')
			->where('o.id = :id AND o.isPaid = 1')
			->setMaxResults(1)
			->setParameter('id', $orderId)
			->setParameter('payment', 'cash');

		return count($qb->getQuery()->getArrayResult()) === 1;
	}

	/**
	 * @return bool
	 */
	public function hasOrderReceipt(int $orderId): bool
	{
		$qb = $this->em->createQueryBuilder();
		$qb->select('COUNT(recp.order)')
			->from($this->entityClass, 'recp')
			->join('recp.order', 'o')
			->where($qb->expr()->eq('o.id', $orderId))
			->setMaxResults(1);

		return $qb->getQuery()->getSingleScalarResult() === 1;
	}

}