<?php declare(strict_types=1);

namespace Eet\Model\Repository;

use Core\Model\Helpers\BaseEntityService;
use Eet\Model\Entities\SellerReceiptConfig;
use EshopCatalog\Model\Entities\Seller;

/**
 * Class SellerReceiptConfigs
 * @package Eet\Model\Repository
 * @method SellerReceiptConfig[] getAll()
 */
class SellerReceiptConfigs extends BaseEntityService
{
	/** @var string */
	protected $entityClass = SellerReceiptConfig::class;

	/**
	 * @param int $sellerId
	 * @return SellerReceiptConfig|null
	 */
	public function getBySeller(int $sellerId): ?SellerReceiptConfig
	{
		$qb = $this->getEr()->createQueryBuilder('src');
		$qb->join('src.seller', 's')
		   ->where($qb->expr()->eq('s.id', $sellerId));

		return $qb->getQuery()->getOneOrNullResult();
	}

}