<?php declare(strict_types=1);

namespace Eet\Model\Subscribers;

use Eet\Model\EetConfig;
use Eet\Model\Events\OrderPaidEvent;
use Eet\Model\Providers\EetProviderFactory;
use Eet\Model\Repository\OrderReceipts;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use SlevomatEET\Cryptography\CryptographyService;
use SlevomatEET\Configuration;
use SlevomatEET\EvidenceEnvironment;
use SlevomatEET\Client;
use SlevomatEET\Driver\GuzzleSoapClientDriver;

class OrderPaymentSubscriber implements EventSubscriberInterface
{
	/** @var EetProviderFactory */
	protected EetProviderFactory $eetProviderFactory;

	/** @var OrderReceipts */
	protected OrderReceipts $orderReceipts;

	/**
	 * OrderPaymentSubscriber constructor.
	 * @param EetProviderFactory $eetProviderFactory
	 * @param OrderReceipts $orderReceipts
	 */
	public function __construct(EetProviderFactory $eetProviderFactory, OrderReceipts $orderReceipts)
	{
		$this->eetProviderFactory = $eetProviderFactory;
		$this->orderReceipts = $orderReceipts;
	}

	/**
	 * @return array
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'eet.orderPaidInCash' => ['createReceipt', 100],
			'eshopOrders.admin.orderOnSuccess' => ['createReceipt', 100],
		];
	}

	/**
	 * @param OrderPaidEvent|OrderEvent $event
	 * @throws \Exception
	 */
	public function createReceipt($event): void
	{
		if (!EetConfig::load('enable', false)) {
			return;
		}

		if ($event->order->getPayment()->payment->getIdent() === 'storeCash') {
			$this->eetProviderFactory->create($event->order)->send();
		}
	}

}