<?php declare(strict_types = 1);

namespace EshopAccountant\AdminModule\Presenters;

use EshopAccountant\AdminModule\Components\ExportForm;
use EshopAccountant\AdminModule\Components\IExportFormFactory;
use Override;

class DefaultPresenter extends BasePresenter
{
	#[Override]
	protected function startup(): void
	{
		parent::startup();
		$this->setHeader($this->translator->translate('eshopAccountant.title.eshopAccountant'), 'fas fa-file-invoice-dollar');
	}

	public function actionDefault(): void { }

	protected function createComponentExportForm(IExportFormFactory $factory): ExportForm
	{
		return $factory->create();
	}
}
