<?php declare(strict_types = 1);

namespace EshopAccountant\DI;

use Core\DI\CompilerExtension;
use Nette\PhpGenerator\ClassType;
use Override;

class EshopAccountantExtension extends CompilerExtension
{
	#[Override]
	public function loadConfiguration(): void
	{
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['EshopAccountant' => 'EshopAccountant\*Module\Presenters\*Presenter']);
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->getMethod('initialize');
		$this->getContainerBuilder();

		$init->addBody('EshopAccountant\Model\EshopAccountantConfig::setParams($this->parameters[\'eshopAccountant\']);');
	}
}
