<?php declare(strict_types = 1);

namespace EshopAccountant\FrontModule\Presenters;

use EshopAccountant\Model\EshopAccountantConfig;
use EshopCatalog\AdminModule\Model\Sellers;
use EshopOrders\Model\Orders;
use Nette\Utils\DateTime;

class DefaultPresenter extends BasePresenter
{
	protected Orders $orders;
	protected Sellers $sellers;

	public function __construct(Orders $orders, Sellers $sellers)
	{
		parent::__construct();
		$this->orders  = $orders;
		$this->sellers = $sellers;
	}

	public function actionPohodaOrders(): void
	{
		if ($this->getParameter('key') !== EshopAccountantConfig::load('frontKey')) {
			die('access forbidden');
		}

		$seller = null;
		$sellerId = $this->getParameter('seller');
		if (!$sellerId) {
			$seller = $this->sellers->getSellerForSite($this->sitesService->getCurrentSite()->getIdent());
			if ($seller) {
				$sellerId = $seller->getId();
			}
		}

		if (!$sellerId || !$seller) {
			die('access forbidden');
		}

		$from = $this->getParameter('from');
		if ($from) {
			$from = DateTime::createFromFormat('Y-m-d', $from);
		} else {
			$from = (new DateTime())->modify('-1 month')->setTime(0, 0, 0);
		}

		$to = $this->getParameter('to');
		if ($to) {
			$to = DateTime::createFromFormat('Y-m-d', $to);
		} else {
			$to = (new DateTime())->setTime(23, 59, 59);
		}

		$orders = $this->orders->getByDateAndSeller($sellerId, $from, $to);

		$response = $this->getHttpResponse();
		$response->setContentType('text/xml');
		$response->addHeader('Content-Disposition', 'attachment; filename="export.xml"');

		$template = clone $this->template;
		echo $template->renderToString(__DIR__ . '/../../AdminModule/Components/ExportForm_ordersXml.latte', [
			'sellers' => [$seller],
			'orders'  => $orders,
		]);

		exit;
	}
}
