<?php declare(strict_types = 1);

namespace EshopAccountant\Model;

use Core\Model\Router\RouteHelper;
use Core\Model\Router\RouteList;

class RouterFactory
{
	public function __construct(
		protected RouteHelper $routeHelper,
	)
	{
	}

	public function createRouter(): RouteList
	{
		$router = new RouteList;

		$front   = $router[] = new RouteList('EshopAccountant:Front');
		$front[] = $this->routeHelper->createRoute('/eshop-accountant/default/pohoda-orders', 'Default:pohodaOrders');

		return $router;
	}
}
