<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\AdminModule\Components\VirtualCategory;

use Core\Model\Event\Event;
use EshopAdvancedFeature\AdminModule\Model\VirtualCategories;
use EshopCatalog\AdminModule\Components\Categories\RelatedForm as RelatedFormCategories;

class RelatedForm extends RelatedFormCategories
{
	/** @var VirtualCategories|null @inject */
	public ?VirtualCategories $virtualCategories = null;

	/********************
	 * ==== HANDLE
	 */

	public function handleAdd(): void
	{
		$target = (int) $this->getPost('target');
		$key    = (string) $this->getPost('key');

		$result = $this->virtualCategories->addRelated($this->categoryId, $target, $key);
		if ($result) {
			$this->getPresenter()->flashMessageSuccess('default.saved');
		} else {
			$this->getPresenter()->flashMessageDanger('default.error');
		}

		$this->getPresenter()->payload->result = $result ? 'ok' : 'error';
		$this->getPresenter()->payload->id     = $result->getId();
		$this->getPresenter()->payload->key    = $this->t('eshopCatalog.relatedForm.targetKeys.' . $result->targetKey);
		$this->getPresenter()->redrawControl('flashes');
	}

	public function handleRemove(): void
	{
		$id = (int) $this->getPost('id');

		$result = $this->virtualCategories->removeRelated($id);
		if ($result) {
			$this->getPresenter()->flashMessageSuccess('default.removed');
		} else {
			$this->getPresenter()->flashMessageDanger('default.removeFailed');
		}

		$this->getPresenter()->payload->result = $result ? 'ok' : 'error';

		$this->getPresenter()->redrawControl('flashes');
	}

	public function handleChangePosition(): void
	{
		$presenter = $this->getPresenter();
		$request   = $presenter->getHttpRequest();

		$id       = (int) $request->getPost('id');
		$position = (int) $request->getPost('position');

		if ($id) {
			if ($this->virtualCategories->setPosition($id, $position))
				$presenter->flashMessageSuccess('default.positionChanged');
			else
				$presenter->flashMessageDanger('default.positionChangeFailed');
		}

		$presenter->redrawControl('flashes');
	}

	public function getRelated(): array
	{
		$arr       = [];
		$preloaded = [];
		$roots     = array_flip($this->frontCategories->getAllRootIds());
		$rootsById = $this->frontCategories->getRootsForIds();
		$related   = $this->virtualCategories->getByFeatureNavigation($this->categoryId);

		$event = new Event([
			'related' => $related,
			'arr'     => &$preloaded,
		]);
		$this->eventDispatcher->dispatch($event, RelatedFormCategories::class . '::getRelated');

		foreach ($related as $id => $row) {
			if (isset($preloaded[$id])) {
				$arr[$id] = $preloaded[$id];
			} else {
				$name = '';
				if ($row['targetKey'] === 'category') {
					$cat  = $this->frontCategories->getCategories($rootsById[$row['targetId']])[$row['targetId']];
					$name = $roots[$cat->getRootId()] . ' > ' . ($cat->getParent() ? $cat->getParentPathStringFlipped() . ' > ' : '') . $cat->name;
				}

				$arr[$id] = $row + [
						'name' => $name,
					];
			}
		}

		return $arr;
	}
}
