<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopAdvancedFeature\Model\Entities\VirtualCategory;
use EshopAdvancedFeature\Model\Entities\VirtualCategoryRelated;

/**
 * @method VirtualCategory|null|object getReference($id)
 * @method VirtualCategory[]|null getAll()
 * @method VirtualCategory|null get($id)
 */
class VirtualCategories extends BaseEntityService
{
	protected $entityClass = VirtualCategory::class;

	public function addRelated(int $virtualCategory, int $target, string $key = 'category'): ?VirtualCategoryRelated
	{
		try {
			$entity            = new VirtualCategoryRelated($this->em->getReference(VirtualCategory::class, $virtualCategory), $target);
			$entity->targetKey = $key;

			$this->em->persist($entity);
			$this->em->flush();

			return $entity;
		} catch (\Exception $e) {

		}

		return null;
	}

	public function removeRelated(int $id): bool
	{
		if ($entity = $this->em->getRepository(VirtualCategoryRelated::class)->find($id)) {
			$this->em->remove($entity);
			$this->em->flush();

			return true;
		}

		return false;
	}

	public function getByFeatureNavigation(int $id): array
	{
		$arr = [];

		foreach ($this->em->getRepository(VirtualCategoryRelated::class)->createQueryBuilder('vcr')
			         ->where('vcr.virtualCategory = :id')
			         ->setParameter('id', $id)
			         ->orderBy('vcr.position')
			         ->getQuery()->getArrayResult() as $row) {
			$arr[$row['id']] = $row;
		}

		return $arr;
	}

	public function setPosition($id, $position): bool
	{
		if ($item = $this->em->getRepository(VirtualCategoryRelated::class)->find($id)) {
			$item->setPosition((int) $position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}
}
