<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\AdminModule\Presenters;

use EshopAdvancedFeature\AdminModule\Components\Group\GroupsGrid;
use EshopAdvancedFeature\AdminModule\Components\Group\IGroupsGridFactory;
use EshopAdvancedFeature\AdminModule\Components\VirtualCategory\IVirtualCategoriesGridFactory;
use EshopAdvancedFeature\AdminModule\Components\VirtualCategory\VirtualCategoriesGrid;
use Nette\Application\UI\Multiplier;

class DefaultPresenter extends BasePresenter
{
	protected const ICON = 'far fa-newspaper';

	protected function startup()
	{
		parent::startup();
		$this->setHeader('eshopAdvancedFeature.title.virtualCategories', self::ICON);
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionVirtualCategories(): void
	{

	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentVirtualCategoriesGrid(IVirtualCategoriesGridFactory $factory): Multiplier
	{
		return new Multiplier(function(string $siteIdent) use ($factory): VirtualCategoriesGrid {
			return $factory->create($siteIdent);
		});
	}

	protected function createComponentVirtualCategoryGroupsGrid(IGroupsGridFactory $factory): GroupsGrid { return $factory->create(); }
}
