<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\CronModule\Presenters;

use Core\Model\Entities\EntityManagerDecorator;
use EshopAdvancedFeature\CronModule\Model\Navigations;
use EshopAdvancedFeature\Model\Entities\FeatureNavigation;
use EshopAdvancedFeature\Model\Entities\FeatureNavigationGroup;
use EshopAdvancedFeature\Model\Entities\FeatureNavigationGroupFilter;
use EshopAdvancedFeature\Model\Entities\FeatureNavigationGroupText;
use EshopAdvancedFeature\Model\Entities\FeatureNavigationInGroup;
use EshopAdvancedFeature\Model\Entities\FeatureNavigationRelated;
use EshopAdvancedFeature\Model\Entities\FeatureNavigationText;
use EshopAdvancedFeature\Model\Migrator;
use Nette\Application\ForbiddenRequestException;
use Nette\Utils\Finder;
use Tracy\Debugger;

class DefaultPresenter extends BasePresenter
{
	/** @var EntityManagerDecorator|null @inject */
	public ?EntityManagerDecorator $em = null;

	/** @var Migrator|null @inject */
	public ?Migrator $migrator = null;

	public function actionNavigations(): void
	{
		ini_set('memory_limit', '4G');
		if (!$this->getUser()->isAllowed('Core:Admin', 'access'))
			throw new ForbiddenRequestException();

		$lang = $this->getParameter('lang', 'cs');
		$data = [];

		foreach ($this->em->getConnection()->fetchAllAssociative("SELECT vc.id, vc.site_ident, vct.url, vct.h1 
					FROM eshop_advanced_feature__virtual_category vc
					INNER JOIN eshop_advanced_feature__virtual_category_text vct ON vc.id = vct.id AND vct.locale = '{$lang}'
					WHERE vc.is_locked = 1") as $row) {
			$data[] = [
				'id'   => (string) $row['id'],
				'name' => $row['site_ident'] . ' -> ' . $row['h1'] . ' ' . $row['url'],
			];
		}

		$this->sendJson($data);
	}
}
