<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\FrontModule\Presenters;

use EshopAdvancedFeature\Model\VirtualCategories;
use Pages\FrontModule\Model\Dao\DaoTemplatePage;
use Pages\FrontModule\Model\TemplatePages;
use Pages\Model\Paths;

class DefaultPresenter extends BasePresenter
{
	protected VirtualCategories $virtualCategories;
	protected Paths             $pathsService;
	protected TemplatePages     $templatePagesService;

	protected ?DaoTemplatePage $templatePage = null;

	public function __construct(
		VirtualCategories $virtualCategories,
		Paths             $pathsService,
		TemplatePages     $templatePagesService
	)
	{
		$this->virtualCategories    = $virtualCategories;
		$this->pathsService         = $pathsService;
		$this->templatePagesService = $templatePagesService;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionVirtualCategoryGroup(int $id): void
	{
		$this->templatePage = $templatePage = $this->templatePagesService->get((int) $this->getActiveNavigation()->componentParams['templatePage']);

		$this->template->setFile($this->pathsService->getTemplatePagesFile($templatePage->getTemplate()));
	}

	/*******************************************************************************************************************
	 * ============================== Render
	 */

	public function renderVirtualCategoryGroup()
	{
		$nav = $this->getActiveNavigation();

		$this['eshopNavigation']->currentCategoryId = 'virtualCategory_' . $nav->componentParams['group'];

		$templatePage = $this->templatePage;

		$this->template->templateTextValues = $templatePage->getTexts();
		$this->template->pageClass          .= ' page-eshopcatalog-category page-eshopcatalog-category--virtual';

		$this->template->categoryName = $nav->title;
		$this->template->description  = $nav->description;
		$this->template->pageTitle    = $nav->title;
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */
}
