<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Consumers;

use Bunny\Message;
use Contributte\RabbitMQ\Consumer\IConsumer;
use Core\Model\Entities\EntityManagerDecorator;
use EshopAdvancedFeature\Model\VirtualCategories;
use Nette\Utils\Json;

class VirtualCategoryConsumer implements IConsumer
{
	protected VirtualCategories      $virtualCategories;
	protected EntityManagerDecorator $em;

	public function __construct(
		VirtualCategories      $virtualCategories,
		EntityManagerDecorator $em
	)
	{
		$this->virtualCategories = $virtualCategories;
		$this->em                = $em;
	}

	public function consume(Message $message): int
	{
		$data    = Json::decode($message->content, Json::FORCE_ARRAY);
		$headers = $message->headers;

		$data = $data['data'] ?? null;

		if ($data) {
			$this->virtualCategories->checkForNew($data);
		}

		gc_collect_cycles();
		$this->em->clear();

		return IConsumer::MESSAGE_ACK;
	}

}
