<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_advanced_feature__feature_navigation_group")
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener"})
 */
class FeatureNavigationGroup
{
	use TId;
	use TTranslateListener;

	/**
	 * @var FeatureNavigationGroupText[]|ArrayCollection
	 * @ORM\OneToMany(targetEntity="FeatureNavigationGroupText", mappedBy="featureNavigationGroup", indexBy="lang")
	 */
	protected $texts;

	/**
	 * @var string|null
	 * @ORM\Column(name="ico", type="string", length=255, nullable=true)
	 */
	public ?string $ico = null;

	/**
	 * @var ArrayCollection|FeatureNavigationInGroup[]
	 * @ORM\OneToMany(targetEntity="FeatureNavigationInGroup", mappedBy="group", cascade={"all"})
	 * @ORM\OrderBy({"position" = "ASC"})
	 */
	public $featureNavigations;

	/**
	 * @var FeatureNavigationGroupFilter[]|ArrayCollection
	 * @ORM\OneToMany(targetEntity="FeatureNavigationGroupFilter", mappedBy="group", indexBy="feature_id")
	 * @ORM\OrderBy({"position" = "ASC"})
	 */
	public $filters;

	public function __construct()
	{
		$this->texts              = new ArrayCollection();
		$this->featureNavigations = new ArrayCollection();
		$this->filters            = new ArrayCollection();
	}

	public function getTexts() { return $this->texts; }

	public function getText(?string $lang = null): ?FeatureNavigationGroupText { return $this->texts[$lang ?: $this->locale] ?? null; }

	public function setTexts(array $texts)
	{
		$this->texts = new ArrayCollection($texts);
	}
}
