<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Feature;

/**
 * @ORM\Table(name="eshop_advanced_feature__feature_navigation_group_filter")
 * @ORM\Entity
 */
class FeatureNavigationGroupFilter
{
	/**
	 * @var FeatureNavigationGroup
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="FeatureNavigationGroup", inversedBy="filters")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public FeatureNavigationGroup $group;

	/**
	 * @var Feature
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Feature")
	 * @ORM\JoinColumn(name="feature_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Feature $feature;

	/**
	 * @var int
	 * @ORM\Column(name="position", type="integer")
	 */
	public int $position;

	public function __construct(FeatureNavigationGroup $group, Feature $feature, int $position)
	{
		$this->group    = $group;
		$this->feature  = $feature;
		$this->position = $position;
	}
}
