<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Core\Model\Entities\TLang;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_advanced_feature__feature_navigation_group_text")
 * @ORM\Entity
 */
class FeatureNavigationGroupText
{
	use TLang;

	/**
	 * @var FeatureNavigationGroup
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="FeatureNavigationGroup", inversedBy="texts")
	 * @ORM\JoinColumn(name="feature_navigation_group_id", onDelete="CASCADE", nullable=false)
	 */
	protected FeatureNavigationGroup $featureNavigationGroup;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", nullable=true)
	 */
	public string $title;

	public function __construct(FeatureNavigationGroup $group, string $lang, string $title)
	{
		$this->featureNavigationGroup = $group;
		$this->title                  = $title;
		$this->setLang($lang);
	}

	public function getGroup(): FeatureNavigationGroup { return $this->featureNavigationGroup; }
}
