<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Helpers\Strings;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("eshop_advanced_feature__feature_navigation_text", indexes={@ORM\Index(name="eaffnt_url", columns={"url"})})
 * @ORM\Entity
 */
class FeatureNavigationText
{
	use TId;

	/**
	 * @var FeatureNavigation
	 * @ORM\ManyToOne(targetEntity="FeatureNavigation", inversedBy="texts")
	 * @ORM\JoinColumn(name="feature_navigation_id", onDelete="CASCADE", nullable=false)
	 */
	protected FeatureNavigation $featureNavigation;

	/**
	 * @ORM\Column(name="locale", type="string", length=255, nullable=false)
	 */
	protected string $locale;

	/**
	 * @ORM\Column(name="url", type="string", nullable=false)
	 */
	protected string $url;

	/**
	 * @ORM\Column(name="page_title", type="string", nullable=true)
	 */
	public ?string $pageTitle = null;

	/**
	 * @ORM\Column(name="filtering_title", type="string", nullable=true)
	 */
	protected ?string $filteringTitle = null;

	/**
	 * @ORM\Column(name="page_description", type="text", nullable=true)
	 */
	public ?string $pageDescription = null;

	/**
	 * @ORM\Column(name="h1", type="string", nullable=true)
	 */
	public ?string $h1 = null;

	/**
	 * @ORM\Column(name="menu_title", type="string", length=255, nullable=true)
	 */
	public ?string $menuTitle = null;

	/**
	 * @ORM\Column(name="description", type="text", nullable=true)
	 */
	public ?string $description = null;

	/**
	 * @ORM\Column(name="long_description", type="text", nullable=true)
	 */
	public ?string $longDescription = null;

	/**
	 * @ORM\Column(name="last_check", type="datetime", nullable=true)
	 */
	public ?\DateTimeInterface $lastCheck = null;

	/**
	 * @ORM\Column(name="last_status", type="string", length=255, nullable=true)
	 */
	public ?string $lastStatus = null;

	public function __construct(FeatureNavigation $featureNavigation, string $locale, string $url)
	{
		$this->featureNavigation = $featureNavigation;
		$this->locale            = $locale;
		$this->setUrl($url);
	}

	public function getFeatureNavigation(): FeatureNavigation { return $this->featureNavigation; }

	public function setUrl(string $url) { $this->url = Strings::webalize($url); }

	public function getUrl(): string { return $this->url; }

	public function setFilteringTitle(?string $title) { $this->filteringTitle = $title; }

	public function getFilteringTitle(): string { return $this->filteringTitle ?: $this->pageTitle; }

	public function getFilteringTitleRaw(): ?string { return $this->filteringTitle; }

	public function updateCheck(string $status)
	{
		$this->lastCheck  = new DateTime();
		$this->lastStatus = $status;
	}
}
