<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_advanced_feature__virtual_category_group")
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener"})
 */
class VirtualCategoryGroup
{
	use TId;
	use TTranslateListener;

	/**
	 * @var ArrayCollection<VirtualCategoryGroupText>
	 * @ORM\OneToMany(targetEntity="VirtualCategoryGroupText", mappedBy="group", indexBy="lang")
	 */
	public Collection $texts;

	/**
	 * @ORM\Column(name="icon", type="string", length=255, nullable=true)
	 */
	public ?string $icon = null;

	/**
	 * @var ArrayCollection<VirtualCategoryInGroup>
	 * @ORM\OneToMany(targetEntity="VirtualCategoryInGroup", mappedBy="group")
	 * @ORM\OrderBy({"position"="ASC"})
	 */
	public Collection $virtualCategoriesInGroup;

	/**
	 * @var ArrayCollection<VirtualCategoryGroupFilter>
	 * @ORM\OneToMany(targetEntity="VirtualCategoryGroupFilter", mappedBy="group", indexBy="feature_id")
	 * @ORM\OrderBy({"position"="ASC"})
	 */
	public Collection $filters;

	public function __construct()
	{
		$this->texts                    = new ArrayCollection();
		$this->virtualCategoriesInGroup = new ArrayCollection();
		$this->filters                  = new ArrayCollection();
	}

	public function getText(?string $lang = null): ?VirtualCategoryGroupText { return $this->texts[$lang ?: $this->locale] ?? null; }
}
