<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Feature;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="eshop_advanced_feature__virtual_category_group_filter")
 * @ORM\Entity
 */
class VirtualCategoryGroupFilter
{
	/**
	 * @ORM\Id
	 * @Gedmo\SortableGroup
	 * @ORM\ManyToOne(targetEntity="VirtualCategoryGroup", inversedBy="filters")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public VirtualCategoryGroup $group;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Feature")
	 * @ORM\JoinColumn(name="feature_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Feature $feature;

	/**
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer", options={"unsigned": true, "default": 0}, nullable=false)
	 */
	public int $position;

	public function __construct(
		VirtualCategoryGroup $group,
		Feature              $feature
	)
	{
		$this->group    = $group;
		$this->feature  = $feature;
		$this->position = 0;
	}
}
