<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_advanced_feature__virtual_category_group_text", indexes={@ORM\Index(name="group_lang", columns={"group_id", "lang"})})
 * @ORM\Entity
 */
class VirtualCategoryGroupText
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="VirtualCategoryGroup", inversedBy="texts")
	 * @ORM\JoinColumn(name="group_id", onDelete="CASCADE", nullable=false)
	 */
	protected VirtualCategoryGroup $group;

	/**
	 * @ORM\Column(name="lang", type="string", length=2, nullable=false)
	 */
	public string $lang;

	/**
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public string $title;

	public function __construct(
		VirtualCategoryGroup $group,
		string               $lang,
		string               $title
	)
	{
		$this->group = $group;
		$this->lang  = $lang;
		$this->title = $title;
	}

	public function getGroup(): VirtualCategoryGroup { return $this->group; }
}
