<?php declare(strict_types = 1);

namespace EshopAdvancedFeature\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="eshop_advanced_feature__virtual_category_in_group")
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 */
class VirtualCategoryInGroup
{
	use TId;

	/**
	 * @Gedmo\SortableGroup
	 * @ORM\ManyToOne(targetEntity="VirtualCategoryGroup", inversedBy="virtualCategoriesInGroup")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public VirtualCategoryGroup $group;

	/**
	 * @ORM\ManyToOne(targetEntity="VirtualCategory", inversedBy="inGroups")
	 * @ORM\JoinColumn(name="virtual_category_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public VirtualCategory $virtualCategory;

	/**
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer", options={"unsigned": true, "default": 0}, nullable=false)
	 */
	public int $position;

	public function __construct(
		VirtualCategoryGroup $virtualCategoryGroup,
		VirtualCategory      $virtualCategory
	)
	{
		$this->group           = $virtualCategoryGroup;
		$this->virtualCategory = $virtualCategory;
		$this->position        = 0;
	}
}
